#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/7dV3zt

////////////////////////////////
// Terrain generation section //
////////////////////////////////

float snoise(vec2 p) {
	vec2 f = fract(p);
	p = floor(p);
	float v = p.x+p.y*1000.0;
	vec4 r = vec4(v, v+1.0, v+1000.0, v+1001.0);
	r = fract(100000.0*sin(r*.001));
	f = f*f*(3.0-2.0*f);
	return 2.0*(mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y))-1.0;
}

float noise(in vec2 uv)
{
    return sin(uv.x)+cos(uv.y);
}

float terrain(in vec2 uv,int octaves)
{
    //float scale_factor = 1.;
    //uv /= scale_factor;
    //this function generates the terrain height
    float value = 0.;
    float amplitude = 1.;
    float freq = .5;
    float n1 = 0.;
    
    //float f2 = .1; //this constant changes the variation in mountain height
    
    //float f1 = f2;
    //float f3 = 1.-f1;
    //vec2 uv1 = uv;
    for (int i = 0; i < octaves; i++)
    {
        //uv += vec2(amplitude,freq);
        n1 = (noise((uv) * freq-n1*value)-n1);
        // From Dave_Hoskins https://www.shadertoy.com/user/Dave_Hoskins
        
        
        value = (value+n1 * amplitude)+amplitude;
        freq *= 2.55-amplitude;
        amplitude *= 1./2.-value/2./2./2.;
        
        
        //float f1 = f2*(f3+f1)*noise(uv);
        //uv = uv.yx;
        uv = uv.yx-n1/freq;
        //uv1 = uv1.yx;
        //uv = uv.yx/(1.+amplitude);
        //uv = uv.yx+noise(uv/freq)*amplitude+noise(uv.yx*amplitude)*freq;
        //value *= f3+f1;
        //freq += f1;
        
        //value *= .9;

}
    return value;
}


vec2 map(vec3 p, int octaves) {
	float dMin = 28.0;
	float d;
	float mID = -1.0;
	
	// Mountains
	float h = terrain(p.xz, octaves);
	//h += smoothstep(0.0, 1.1, h);
    //h += smoothstep(-0.1, 1.0, p.y)*0.6;
	d = p.y - h;
	if (d<dMin) { 
		dMin = d;
		mID = 0.0;
	}

	return vec2(dMin, mID);
}

////////////////////
// Render section //
////////////////////

vec2 castRay(vec3 ro, vec3 rd, int octaves) {
	const float p = 0.001;
	float t = 0.0;
	float h = p * 2.0;
	float m = -1.0;
	for (int i=0; i<36; i++) {
		if (abs(h)<=p || t>=28.0) break;
        t += h;
        vec2 res = map(ro + rd*t, octaves);
        h = res.x;
        m = res.y;
	}
	if (t>28.0) m = -1.0;
	return vec2(t, m);
}

vec3 calcNormal(vec3 p, int octaves) {
	const vec3 eps = vec3(0.002, 0.0, 0.0);
	return normalize( vec3(map(p+eps.xyy, octaves).x - map(p-eps.xyy, octaves).x,
			       map(p+eps.yxy, octaves).x - map(p-eps.yxy, octaves).x,
			       map(p+eps.yyx, octaves).x - map(p-eps.yyx, octaves).x) );
}

float shadows(vec3 ro, vec3 rd, float tMax, float k, int octaves) {
    float res = 1.0;
	float t = 0.1;
	for(int i=0; i<22; i++) {
        if (t>=tMax) break;
        float h = map(ro + rd*t, octaves).x;
        res = min( res, k*h/t );
        t += h;
    }
    return clamp(res, 0.2, 1.0);
}

vec3 render(vec3 ro, vec3 rd) {
	const int geoLOD = 4;
	
	vec2 res = castRay(ro, rd, geoLOD);
	
	vec3 lPos = normalize(vec3(1.0, 0.5, 0.0));
	vec3 lCol = vec3(1.0, 0.9, 0.8);
	
	vec3 pos = ro + rd*res.x;
	
	// mat -1 = Background / sky
    vec3 color = vec3(0.45,0.5,0.6);
    float sun = clamp(dot(rd,lPos),0.0,1.0);
    color += 0.6 * lCol * sun*sun;
    if (res.y < -0.5) {
		return color;
	}
    
    vec3 skyColor = color;
	
	int norLOD = int(max(2.0, 12.0-11.0*res.x/28.0));
	vec3 nor = calcNormal(pos, norLOD);
	
	// mat 0 = Rock / mountain
	if (res.y>-0.5 && res.y<0.5) {
		// Base rock
		color = mix( vec3(0.4, 0.1, 0.0), vec3(0.7, 0.6, 0.3), step(0.9, nor.y) );
		
		// Layer noise
		float n = 0.5*(snoise(pos.xy*vec2(2.0, 15.0))+1.0);
		color = mix( vec3(0.6, 0.5, 0.4), color, n*smoothstep(0.0, 0.7, 1.0-nor.y) );
		
        // Sand on top
        color = mix(color, vec3(0.7, 0.6, 0.3), smoothstep(0.0, 0.2, nor.y-0.8));
	}
	// mat 1 = Sand
	if (res.y>0.5) {
		// Base sand and rock color
		color = mix( vec3(0.3, 0.2, 0.0), vec3(0.7, 0.6, 0.3), nor.y );
	}
	
    // Lighting and shadows
    float lAmb = clamp( 0.5 + 0.5 * nor.y, 0.0, 1.0);
    float lDif = clamp( dot( nor, lPos ), 0.0, 2.0);

    if (lDif>0.05) lDif *= shadows(pos, lPos, 8.0, 12.0, geoLOD);

    color += (0.4*lAmb) * lCol;
    color *= (1.8*lDif) * lCol;	
    
	// Fog
	float fog = exp(-0.003 *res.x*res.x);
	color = mix(skyColor, color, fog);
		
	return color;
}

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
	vec2 pos = 2.0 * ( fragCoord.xy / iResolution.xy ) - 1.0;
	pos.x *= iResolution.x / iResolution.y;
    float t1 = iTime;
	// Camera
	float x = 0.0 + (0.5*t1);
	float y = 0.0;
	float z = 0.0 + sin(0.1*t1);
	vec3 cPos = vec3(x, y, z);
	cPos.y = terrain(cPos.xz, 1) + 2.5;
	
	const vec3 cUp = vec3(0., 1., 0.);
	vec3 cLook = vec3(cPos.x + 1.0, cPos.y*0.85, 0.0);
	
	// Camera matrix
	vec3 ww = normalize( cLook-cPos );
	vec3 uu = normalize( cross(ww, cUp) );
	vec3 vv = normalize( cross(uu, ww) );
	
	vec3 rd = normalize( pos.x*uu + pos.y*vv + 2.0*ww );
	
	// Render
	vec3 color = render(cPos, rd);
	
	fragColor = vec4( color, 1.0 );
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


